

edgeC   = CreateColor(0, 255, 255, 100);
boundC   = CreateColor(255, 255, 0, 100);

//point = LoadImage("arrow.png")



//------------------------------ Image Object Arrays.-------------------------


//----------------------------------Object constructors--------------------------------
function ImageObject(pic, x,y)
 {
  this.pic = LoadImage(pic)
  this.width = this.pic.width
  this.height = this.pic.height
  //this.dragPoint = LoadImage("register.png")

  
  this.X = x
  this.Y = y
  
  this.Xoffset = ( (50 * Math.ceil(this.width/50)) - this.width)/2
  this.Yoffset = ( (50 * Math.ceil(this.height/50)) - this.height)/2



 //Registrations (for drawing centered images, etc.) --------------
  this.Registrations = new Array()  
  this.Registrations[0] = {x:(-Math.ceil(this.width/2)), y:(-Math.ceil(this.height/2))}  
  // center point

  this.Registrations[1] = {x:0, y:0}              
  //top Left !Normal! position  
  this.Registrations[2] = {x:(-Math.ceil(this.width/2)), y:0} 
  //center top.
  this.Registrations[3] = {x:-this.width, y:0}     
  //top right  
  this.Registrations[4] = {x:0, y:(-Math.ceil(this.height/2))}              
  //mid Left 
  this.Registrations[5] = {x:-this.width, y:(-Math.ceil(this.height/2))}     
  //mid right  
  this.Registrations[6] = {x:0, y:-this.height}              
  //bottom Left !Normal! position
  this.Registrations[7] = {x:(-Math.ceil(this.width/2)), y:-this.height}
  //bottom center.
  this.Registrations[8] = {x:-this.width, y:-this.height}     
  //bottom right  

  this.rPoint = this.Registrations[0] // Registration Point (center, top left edge, etc..)
  this.rVal = 1 // the number of the currently used registration.

 //methods--------------
  this.moveTo = moveTo;
  this.draw = draw;
  this.drawRot = drawRot
  this.setRegistrations = setRegistrations;
  this.drawEdges = drawEdges;
  this.drawBoundary = drawBoundary;
  this.drawDragPoint = drawDragPoint;
  this.dragged = false
  this.snapTo = true
  
  
  this.activeField = new Array;
  this.activeField[0] = this.X
  this.activeField[1] = this.Y
  this.activeField[2] = this.X + this.width
  this.activeField[3] = this.Y + this.height
  

  this.updateField = updateField;
        
 }
 
 
//----------------------------------Methods----------------------------------------
function moveTo(x,y)
 {
  this.X = x
  this.Y = y
  this.updateField();
 }

function updateField()
 {
  this.activeField[0] = this.X
  this.activeField[1] = this.Y
  this.activeField[2] = this.X + this.width
  this.activeField[3] = this.Y + this.height
 } 
 
function draw()
 {
  this.pic.blit( (this.X + this.rPoint.x) , (this.Y + this.rPoint.y) );
 }

function drawRot(rot)
 {
  this.pic.rotateBlit( (this.X + this.rPoint.x) , (this.Y + this.rPoint.y), rot );
 }

function setRegistrations(Num)
 {
  this.rVal = Num
  this.rPoint = this.Registrations[this.rVal]    
 }

function drawEdges()
 {
  Rectangle( (this.X + this.rPoint.x), (this.Y + this.rPoint.y), this.width, this.height, edgeC)
 
 }
 
function drawBoundary()
 {
  x = (50 * Math.ceil(this.width/50))
  y = (50 * Math.ceil(this.height/50))

  boundX = this.rPoint.x - ((x - this.width)/2)
  boundY = this.rPoint.y - ((y - this.height)/2)
//  Rectangle( (this.X + this.Registrations[0].x  ), (this.Y + this.Registrations[0].y + (y/4)), x, y, boundC);
  //Rectangle( (this.X + this.rPoint.x - ((x - this.width)/2) ), (this.Y + this.rPoint.y - ((y - this.height)/2)), x, y, boundC);
  Rectangle( (this.X + boundX ), (this.Y + boundY), x, y, boundC);

//Rectangle( (this.X + this.rPoint.x), (this.Y + this.rPoint.y), 100, 100, boundC)

 }

function drawDragPoint()
 {
  this.dragPoint.blit(this.X - 5,this.Y - 5)  
 }


function grid()
 {
  for (var x = 0; x < 14; x++)
   {Line (x*50,0,x*50,480,Red) }
  for (var y = 0; y < 10; y++)
   {Line (0,y*50,640,y*50,Red) }
 } 
//----------------------------------Objects----------------------------------------
//------------Testors-------------------------------------------

 